/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.problems;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Problem
implements Serializable {
    private static final long serialVersionUID = -527349386380044656L;
    static final Logger log = LoggerFactory.getLogger(Problem.class);
    private static final String UNKNOWN_ERROR_CODE = "00000";
    private static final String NO_SCOPE = null;
    private static final String NO_REFERENCE = null;
    @VisibleForTesting
    static final Map<String, Level> errorCodeLevels = Maps.newHashMap();
    private final Level level;
    private final String errorCode;
    private final String scope;
    private final String reference;
    private final long time;
    private final List<Tuple<String, String>> associatedEntities;

    public Problem(Level level, String errorCode, String scope, String reference, long time, List<Tuple<String, String>> associatedEntities) {
        this.level = level;
        this.errorCode = errorCode;
        this.scope = scope;
        this.reference = reference;
        this.time = time;
        this.associatedEntities = associatedEntities;
    }

    public Problem(Level level, String message) {
        this.level = level;
        this.errorCode = UNKNOWN_ERROR_CODE;
        this.scope = NO_SCOPE;
        this.reference = NO_REFERENCE;
        this.time = Calendar.getInstance().getTimeInMillis();
        this.associatedEntities = Lists.newArrayListWithCapacity(1);
        this.associatedEntities.add(Tuple.create(message, null));
    }

    @Deprecated
    public static Problem error(String message) {
        return new Problem(Level.ERROR, message);
    }

    @Deprecated
    public static Problem warning(String message) {
        return new Problem(Level.WARNING, message);
    }

    public static Problem createProblem(String errorCode, @Nullable String scope, @Nullable String reference, boolean nullAuto, Object ... args) {
        Level l = errorCodeLevels.get(errorCode);
        if (l != null) {
            ArrayList<Tuple<String, String>> associatedEntities = Lists.newArrayListWithCapacity(args.length);
            for (Object arg : args) {
                if (arg == null) {
                    associatedEntities.add(Tuple.create(null, null));
                    continue;
                }
                if (arg instanceof GeneralizedOrderRequest) {
                    GeneralizedOrderRequest gor = (GeneralizedOrderRequest)arg;
                    associatedEntities.add(Tuple.create(gor.getId(), "gor"));
                    continue;
                }
                if (arg instanceof CustomerRequest) {
                    CustomerRequest cr = (CustomerRequest)arg;
                    associatedEntities.add(Tuple.create(cr.getId(), "cr"));
                    continue;
                }
                if (arg instanceof SupplyRequest) {
                    SupplyRequest sr = (SupplyRequest)arg;
                    associatedEntities.add(Tuple.create(sr.getId(), "sr"));
                    continue;
                }
                if (arg instanceof Workplace) {
                    Workplace workplace = (Workplace)arg;
                    associatedEntities.add(Tuple.create(workplace.getName(), "workplace"));
                    continue;
                }
                if (arg instanceof Product) {
                    Product product = (Product)arg;
                    associatedEntities.add(Tuple.create(product.getName(), "product"));
                    continue;
                }
                if (arg instanceof Material) {
                    Material material = (Material)arg;
                    associatedEntities.add(Tuple.create(material.getName(), "material"));
                    continue;
                }
                if (arg instanceof Action) {
                    Action action = (Action)arg;
                    associatedEntities.add(Tuple.create(action.getName(), "action"));
                    continue;
                }
                associatedEntities.add(Tuple.create(arg.toString(), null));
            }
            if (associatedEntities.isEmpty()) {
                return new Problem(l, errorCode, scope, reference, Calendar.getInstance().getTimeInMillis(), associatedEntities);
            }
            if (((Tuple)associatedEntities.get(0)).getSecond() == null) {
                return new Problem(l, errorCode, scope, reference == null && nullAuto ? (String)((Tuple)associatedEntities.get(0)).getFirst() : reference, Calendar.getInstance().getTimeInMillis(), associatedEntities);
            }
            return new Problem(l, errorCode, scope == null && nullAuto ? (String)((Tuple)associatedEntities.get(0)).getSecond() : scope, reference == null && nullAuto ? (String)((Tuple)associatedEntities.get(0)).getFirst() : reference, Calendar.getInstance().getTimeInMillis(), associatedEntities);
        }
        log.error("Error code \"{}\" is not a valid error code.", (Object)errorCode);
        StringBuilder sb = new StringBuilder();
        sb.append("Arguments: ");
        boolean f = true;
        for (Object arg : args) {
            if (!f) {
                sb.append(", ");
            } else {
                f = false;
            }
            sb.append(arg);
        }
        return Problem.createProblem(UNKNOWN_ERROR_CODE, scope, reference, false, sb.toString());
    }

    public static Problem createProblem2(String errorCode, Object ... args) {
        return Problem.createProblem(errorCode, null, null, true, args);
    }

    public Level getLevel() {
        return this.level;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getScope() {
        return this.scope;
    }

    public String getReference() {
        return this.reference;
    }

    public String getMessage() {
        Object[] strings = new String[this.associatedEntities.size()];
        for (int i = 0; i < this.associatedEntities.size(); ++i) {
            strings[i] = this.associatedEntities.get(i).getFirst();
        }
        return Localizer.getString("problems." + this.errorCode, strings);
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return this.time + ": " + this.level + "-" + this.errorCode + ": [" + Localizer.getString("problems.scope") + ": " + this.scope + "; " + Localizer.getString("problems.reference") + ": " + this.reference + "] " + this.getMessage();
    }

    public void logProblem(Logger log) {
        Object logString = UNKNOWN_ERROR_CODE.equals(this.errorCode) ? this.getMessage() : "Problem " + this.errorCode + "(" + this.level + "): [" + Localizer.getString("problems.scope") + ": " + this.scope + "; " + Localizer.getString("problems.reference") + ": " + this.reference + "] " + this.getMessage();
        switch (this.level) {
            case INFO: {
                log.info((String)logString);
                break;
            }
            case WARNING: {
                log.warn((String)logString);
                break;
            }
            default: {
                log.error((String)logString);
            }
        }
    }

    public static Iterable<Problem> asWarnings(Iterable<String> problemStrs) {
        return Iterables.transform(problemStrs, new Function<String, Problem>(){

            @Override
            public Problem apply(String input) {
                return Problem.warning(input);
            }
        });
    }

    public static List<Problem> createList() {
        return Lists.newArrayListWithCapacity(30);
    }

    public static void createLogAdd(Logger log, Collection<Problem> collection, String errorCode, @Nullable String scope, @Nullable String reference, boolean nullAuto, Object ... args) {
        Problem prob = Problem.createProblem(errorCode, scope, reference, nullAuto, args);
        prob.logProblem(log);
        collection.add(prob);
    }

    public static void create2LogAdd(Logger log, Collection<Problem> collection, String errorCode, Object ... args) {
        Problem prob = Problem.createProblem2(errorCode, args);
        prob.logProblem(log);
        collection.add(prob);
    }

    static {
        errorCodeLevels.put(UNKNOWN_ERROR_CODE, Level.WARNING);
        errorCodeLevels.put("00100", Level.ERROR);
        errorCodeLevels.put("00200", Level.ERROR);
        errorCodeLevels.put("00300", Level.WARNING);
        errorCodeLevels.put("00400", Level.ERROR);
        errorCodeLevels.put("00500", Level.WARNING);
        errorCodeLevels.put("00800", Level.ERROR);
        errorCodeLevels.put("00900", Level.WARNING);
        errorCodeLevels.put("01000", Level.ERROR);
        errorCodeLevels.put("01100", Level.ERROR);
        errorCodeLevels.put("01200", Level.ERROR);
        errorCodeLevels.put("01300", Level.WARNING);
        errorCodeLevels.put("01400", Level.WARNING);
        errorCodeLevels.put("01500", Level.WARNING);
        errorCodeLevels.put("01600", Level.WARNING);
        errorCodeLevels.put("01700", Level.ERROR);
        errorCodeLevels.put("01800", Level.ERROR);
        errorCodeLevels.put("01900", Level.ERROR);
        errorCodeLevels.put("02000", Level.WARNING);
        errorCodeLevels.put("02050", Level.WARNING);
        errorCodeLevels.put("02100", Level.ERROR);
        errorCodeLevels.put("02200", Level.ERROR);
        errorCodeLevels.put("02300", Level.ERROR);
        errorCodeLevels.put("02400", Level.ERROR);
        errorCodeLevels.put("02650", Level.WARNING);
        errorCodeLevels.put("02700", Level.WARNING);
        errorCodeLevels.put("02750", Level.WARNING);
        errorCodeLevels.put("02800", Level.WARNING);
        errorCodeLevels.put("02850", Level.WARNING);
        errorCodeLevels.put("02900", Level.ERROR);
        errorCodeLevels.put("02905", Level.ERROR);
        errorCodeLevels.put("02907", Level.ERROR);
        errorCodeLevels.put("02910", Level.ERROR);
        errorCodeLevels.put("02915", Level.ERROR);
        errorCodeLevels.put("02920", Level.ERROR);
        errorCodeLevels.put("02925", Level.ERROR);
        errorCodeLevels.put("02930", Level.ERROR);
        errorCodeLevels.put("02931", Level.ERROR);
        errorCodeLevels.put("02935", Level.ERROR);
        errorCodeLevels.put("02940", Level.ERROR);
        errorCodeLevels.put("02945", Level.ERROR);
        errorCodeLevels.put("02950", Level.ERROR);
        errorCodeLevels.put("02955", Level.ERROR);
        errorCodeLevels.put("02960", Level.ERROR);
        errorCodeLevels.put("02965", Level.ERROR);
        errorCodeLevels.put("02970", Level.ERROR);
        errorCodeLevels.put("02975", Level.ERROR);
        errorCodeLevels.put("02980", Level.ERROR);
        errorCodeLevels.put("02985", Level.ERROR);
        errorCodeLevels.put("02990", Level.ERROR);
        errorCodeLevels.put("02991", Level.ERROR);
        errorCodeLevels.put("03000", Level.WARNING);
        errorCodeLevels.put("03050", Level.WARNING);
        errorCodeLevels.put("03100", Level.WARNING);
        errorCodeLevels.put("03150", Level.ERROR);
        errorCodeLevels.put("03200", Level.ERROR);
        errorCodeLevels.put("03250", Level.ERROR);
        errorCodeLevels.put("03300", Level.WARNING);
        errorCodeLevels.put("03325", Level.ERROR);
        errorCodeLevels.put("03350", Level.ERROR);
        errorCodeLevels.put("03400", Level.ERROR);
        errorCodeLevels.put("03450", Level.WARNING);
        errorCodeLevels.put("03500", Level.ERROR);
        errorCodeLevels.put("03550", Level.WARNING);
        errorCodeLevels.put("03600", Level.ERROR);
        errorCodeLevels.put("03650", Level.WARNING);
        errorCodeLevels.put("03700", Level.ERROR);
        errorCodeLevels.put("03750", Level.WARNING);
        errorCodeLevels.put("03800", Level.ERROR);
        errorCodeLevels.put("03850", Level.ERROR);
        errorCodeLevels.put("03900", Level.ERROR);
        errorCodeLevels.put("03925", Level.ERROR);
        errorCodeLevels.put("03950", Level.ERROR);
        errorCodeLevels.put("04000", Level.WARNING);
        errorCodeLevels.put("04050", Level.WARNING);
        errorCodeLevels.put("04051", Level.WARNING);
        errorCodeLevels.put("04100", Level.ERROR);
        errorCodeLevels.put("04150", Level.WARNING);
        errorCodeLevels.put("30050", Level.ERROR);
        errorCodeLevels.put("30100", Level.ERROR);
        errorCodeLevels.put("30150", Level.ERROR);
        errorCodeLevels.put("30200", Level.ERROR);
        errorCodeLevels.put("30250", Level.ERROR);
        errorCodeLevels.put("30300", Level.WARNING);
        errorCodeLevels.put("30330", Level.ERROR);
        errorCodeLevels.put("30350", Level.ERROR);
        errorCodeLevels.put("30400", Level.ERROR);
        errorCodeLevels.put("30450", Level.WARNING);
        errorCodeLevels.put("30500", Level.ERROR);
        errorCodeLevels.put("30550", Level.ERROR);
        errorCodeLevels.put("30600", Level.ERROR);
        errorCodeLevels.put("30650", Level.ERROR);
        errorCodeLevels.put("30700", Level.ERROR);
        errorCodeLevels.put("30750", Level.ERROR);
        errorCodeLevels.put("30800", Level.WARNING);
        errorCodeLevels.put("30825", Level.ERROR);
        errorCodeLevels.put("30850", Level.ERROR);
        errorCodeLevels.put("30900", Level.ERROR);
        errorCodeLevels.put("30950", Level.ERROR);
        errorCodeLevels.put("31000", Level.ERROR);
        errorCodeLevels.put("31050", Level.ERROR);
        errorCodeLevels.put("31100", Level.ERROR);
        errorCodeLevels.put("31150", Level.WARNING);
        errorCodeLevels.put("31200", Level.WARNING);
        errorCodeLevels.put("31201", Level.WARNING);
        errorCodeLevels.put("31202", Level.WARNING);
        errorCodeLevels.put("31215", Level.WARNING);
        errorCodeLevels.put("31225", Level.WARNING);
        errorCodeLevels.put("31230", Level.WARNING);
        errorCodeLevels.put("31250", Level.WARNING);
        errorCodeLevels.put("31275", Level.WARNING);
        errorCodeLevels.put("31300", Level.ERROR);
        errorCodeLevels.put("31325", Level.WARNING);
        errorCodeLevels.put("31330", Level.ERROR);
        errorCodeLevels.put("31335", Level.ERROR);
        errorCodeLevels.put("31350", Level.ERROR);
        errorCodeLevels.put("31400", Level.ERROR);
        errorCodeLevels.put("31425", Level.ERROR);
        errorCodeLevels.put("31450", Level.WARNING);
        errorCodeLevels.put("31500", Level.ERROR);
        errorCodeLevels.put("31550", Level.WARNING);
        errorCodeLevels.put("31160", Level.ERROR);
        errorCodeLevels.put("31170", Level.ERROR);
        errorCodeLevels.put("31600", Level.WARNING);
        errorCodeLevels.put("31601", Level.WARNING);
        errorCodeLevels.put("31602", Level.WARNING);
        errorCodeLevels.put("31603", Level.WARNING);
        errorCodeLevels.put("31604", Level.WARNING);
        errorCodeLevels.put("31605", Level.WARNING);
        errorCodeLevels.put("31606", Level.WARNING);
        errorCodeLevels.put("31607", Level.WARNING);
        errorCodeLevels.put("31608", Level.WARNING);
        errorCodeLevels.put("31609", Level.WARNING);
        errorCodeLevels.put("31610", Level.WARNING);
        errorCodeLevels.put("31611", Level.WARNING);
        errorCodeLevels.put("31612", Level.WARNING);
        errorCodeLevels.put("31613", Level.WARNING);
        errorCodeLevels.put("31614", Level.WARNING);
        errorCodeLevels.put("31615", Level.WARNING);
        errorCodeLevels.put("31616", Level.WARNING);
        errorCodeLevels.put("31617", Level.WARNING);
        errorCodeLevels.put("31620", Level.ERROR);
        errorCodeLevels.put("31625", Level.ERROR);
        errorCodeLevels.put("31626", Level.ERROR);
        errorCodeLevels.put("31627", Level.ERROR);
        errorCodeLevels.put("31628", Level.ERROR);
        errorCodeLevels.put("31629", Level.ERROR);
        errorCodeLevels.put("31630", Level.WARNING);
        errorCodeLevels.put("31631", Level.ERROR);
        errorCodeLevels.put("31632", Level.WARNING);
        errorCodeLevels.put("31633", Level.ERROR);
        errorCodeLevels.put("31634", Level.WARNING);
        errorCodeLevels.put("31635", Level.ERROR);
        errorCodeLevels.put("31636", Level.ERROR);
        errorCodeLevels.put("31638", Level.ERROR);
        errorCodeLevels.put("31639", Level.ERROR);
        errorCodeLevels.put("31640", Level.WARNING);
        errorCodeLevels.put("31650", Level.ERROR);
        errorCodeLevels.put("31700", Level.ERROR);
        errorCodeLevels.put("31710", Level.ERROR);
        errorCodeLevels.put("31720", Level.WARNING);
        errorCodeLevels.put("31750", Level.ERROR);
        errorCodeLevels.put("31800", Level.ERROR);
        errorCodeLevels.put("31850", Level.ERROR);
        errorCodeLevels.put("31860", Level.WARNING);
        errorCodeLevels.put("31870", Level.ERROR);
        errorCodeLevels.put("31870", Level.ERROR);
        errorCodeLevels.put("31900", Level.ERROR);
        errorCodeLevels.put("31950", Level.ERROR);
        errorCodeLevels.put("32000", Level.ERROR);
        errorCodeLevels.put("32025", Level.ERROR);
        errorCodeLevels.put("32030", Level.ERROR);
        errorCodeLevels.put("32050", Level.ERROR);
        errorCodeLevels.put("32100", Level.WARNING);
        errorCodeLevels.put("32150", Level.WARNING);
        errorCodeLevels.put("32200", Level.ERROR);
        errorCodeLevels.put("32250", Level.ERROR);
        errorCodeLevels.put("32251", Level.ERROR);
        errorCodeLevels.put("33001", Level.ERROR);
        errorCodeLevels.put("33002", Level.ERROR);
        errorCodeLevels.put("33003", Level.ERROR);
        errorCodeLevels.put("33050", Level.WARNING);
        errorCodeLevels.put("34000", Level.WARNING);
        errorCodeLevels.put("70000", Level.ERROR);
        errorCodeLevels.put("70050", Level.ERROR);
        errorCodeLevels.put("70100", Level.ERROR);
        errorCodeLevels.put("70150", Level.WARNING);
        errorCodeLevels.put("70200", Level.WARNING);
        errorCodeLevels.put("70250", Level.WARNING);
        errorCodeLevels.put("70300", Level.ERROR);
        errorCodeLevels.put("70350", Level.WARNING);
        errorCodeLevels.put("70400", Level.WARNING);
        errorCodeLevels.put("70450", Level.CRITICAL);
        errorCodeLevels.put("70550", Level.ERROR);
        errorCodeLevels.put("70600", Level.WARNING);
    }

    public static enum Level implements Comparable<Level>
    {
        INFO,
        WARNING,
        ERROR,
        CRITICAL;

    }
}

